import { useIsDarkMode } from '@/lib/hooks/use-is-dark-mode';
import { useIsMounted } from '@/lib/hooks/use-is-mounted';

export const ErrorFileIcon: React.FC<React.SVGAttributes<{}>> = (props) => {
  const isMounted = useIsMounted();
  const { isDarkMode } = useIsDarkMode();

  return (
    <>
      {isMounted && isDarkMode ? (
        <svg
          fill="none"
          viewBox="0 0 130 126"
          xmlns="http://www.w3.org/2000/svg"
          {...props}
        >
          <path
            d="M61.9847 125.251C96.2179 125.251 123.969 97.3824 123.969 63.0044C123.969 28.6264 96.2179 0.757568 61.9847 0.757568C27.7515 0.757568 0 28.6264 0 63.0044C0 97.3824 27.7515 125.251 61.9847 125.251Z"
            fill="currentColor"
          />
          <path
            d="M112.876 36.0507V46.7358V105.156C112.876 105.156 43.9637 105.156 39.2298 105.156C36.8673 105.156 34.7269 104.193 33.1726 102.641C31.6272 101.08 30.668 98.9397 30.668 96.5583V30.7527H60.2171L64.6312 36.0418H112.876V36.0507Z"
            fill="#F7931E"
          />
          <path
            d="M33.1193 70.0775C45.294 70.0775 55.1635 60.1663 55.1635 47.9401C55.1635 35.714 45.294 25.8027 33.1193 25.8027C20.9447 25.8027 11.0752 35.714 11.0752 47.9401C11.0752 60.1663 20.9447 70.0775 33.1193 70.0775Z"
            fill="white"
          />
          <path
            d="M16.7686 62.7816C16.7686 62.7816 25.6679 74.8849 39.9406 76.1693C39.9406 76.1693 37.285 75.3665 36.0061 69.8902C34.7183 64.4049 18.7314 60.3021 16.7686 62.7816Z"
            fill="white"
          />
          <path
            d="M35.509 47.9401L42.3034 41.1169C42.9607 40.4569 42.9607 39.3777 42.3034 38.7177C41.6462 38.0577 40.5715 38.0577 39.9143 38.7177L33.1199 45.5408L26.3254 38.7177C25.6682 38.0577 24.5935 38.0577 23.9363 38.7177C23.279 39.3777 23.279 40.4569 23.9363 41.1169L30.7307 47.9401L23.9363 54.7632C23.279 55.4233 23.279 56.5025 23.9363 57.1625C24.2649 57.4925 24.7001 57.662 25.1264 57.662C25.5527 57.662 25.9879 57.4925 26.3166 57.1625L33.111 50.3393L39.9054 57.1625C40.234 57.4925 40.6692 57.662 41.0955 57.662C41.5307 57.662 41.9571 57.4925 42.2857 57.1625C42.9429 56.5025 42.9429 55.4233 42.2857 54.7632L35.509 47.9401Z"
            fill="#ED1C24"
          />
          <path
            d="M129.999 46.5308V96.5495C129.999 101.294 126.163 105.148 121.438 105.148H39.2383C43.9633 105.148 47.8001 101.294 47.8001 96.5495V46.5308H129.999Z"
            fill="#FFBD39"
          />
          <path
            d="M78.4077 79.9345C80.0726 78.2626 80.0726 75.5519 78.4077 73.88C76.7429 72.2081 74.0436 72.2081 72.3787 73.88C70.7139 75.5519 70.7139 78.2626 72.3787 79.9345C74.0436 81.6064 76.7429 81.6064 78.4077 79.9345Z"
            fill="#F7931E"
          />
          <path
            d="M68.6371 69.5779C68.193 69.5779 67.7756 69.3103 67.6157 68.8643C67.4025 68.2935 67.6867 67.6692 68.2552 67.4551L79.0019 63.4058C79.5615 63.1917 80.1921 63.4771 80.4052 64.048C80.6184 64.6188 80.3342 65.2431 79.7657 65.4572L69.019 69.5065C68.8946 69.5511 68.7614 69.5779 68.6371 69.5779Z"
            fill="#F7931E"
          />
          <path
            d="M102.895 81.1348C105.219 80.756 106.798 78.5569 106.421 76.2229C106.043 73.889 103.854 72.304 101.529 72.6828C99.2054 73.0616 97.6271 75.2607 98.0042 77.5946C98.3814 79.9286 100.571 81.5135 102.895 81.1348Z"
            fill="#F7931E"
          />
          <path
            d="M108.968 69.5778C108.843 69.5778 108.71 69.551 108.586 69.5064L97.8392 65.4571C97.2707 65.2431 96.9865 64.6098 97.1997 64.0479C97.4128 63.486 98.0434 63.1917 98.603 63.4057L109.35 67.455C109.918 67.6691 110.202 68.3023 109.989 68.8642C109.829 69.3102 109.412 69.5778 108.968 69.5778Z"
            fill="#F7931E"
          />
          <path
            d="M91.4364 93.0174H86.1696C85.5656 93.0174 85.0771 92.5268 85.0771 91.9203C85.0771 91.3138 85.5656 90.8232 86.1696 90.8232H91.4364C92.0403 90.8232 92.5288 91.3138 92.5288 91.9203C92.5288 92.5268 92.0403 93.0174 91.4364 93.0174Z"
            fill="#F7931E"
          />
        </svg>
      ) : (
        <svg
          width="130"
          height="130"
          viewBox="0 0 130 130"
          fill="none"
          xmlns="http://www.w3.org/2000/svg"
        >
          <path
            d="M61.9847 127.252C96.2179 127.252 123.969 99.3827 123.969 65.0047C123.969 30.6267 96.2179 2.75781 61.9847 2.75781C27.7515 2.75781 0 30.6267 0 65.0047C0 99.3827 27.7515 127.252 61.9847 127.252Z"
            fill="#EDEEF0"
          />
          <path
            d="M112.876 38.0509V48.7361V107.157C112.876 107.157 43.9637 107.157 39.2298 107.157C36.8673 107.157 34.7269 106.193 33.1726 104.641C31.6272 103.081 30.668 100.94 30.668 98.5586V32.7529H60.2171L64.6312 38.042H112.876V38.0509Z"
            fill="#F7931E"
          />
          <path
            d="M33.1203 72.0775C45.2949 72.0775 55.1644 62.1663 55.1644 49.9401C55.1644 37.714 45.2949 27.8027 33.1203 27.8027C20.9457 27.8027 11.0762 37.714 11.0762 49.9401C11.0762 62.1663 20.9457 72.0775 33.1203 72.0775Z"
            fill="white"
          />
          <path
            d="M16.7695 64.7818C16.7695 64.7818 25.6689 76.8851 39.9416 78.1695C39.9416 78.1695 37.286 77.3668 36.0071 71.8904C34.7192 66.4051 18.7324 62.3023 16.7695 64.7818Z"
            fill="white"
          />
          <path
            d="M35.509 49.9401L42.3034 43.1169C42.9607 42.4569 42.9607 41.3777 42.3034 40.7177C41.6462 40.0577 40.5715 40.0577 39.9143 40.7177L33.1199 47.5408L26.3254 40.7177C25.6682 40.0577 24.5935 40.0577 23.9363 40.7177C23.279 41.3777 23.279 42.4569 23.9363 43.1169L30.7307 49.9401L23.9363 56.7632C23.279 57.4233 23.279 58.5025 23.9363 59.1625C24.2649 59.4925 24.7001 59.662 25.1264 59.662C25.5527 59.662 25.9879 59.4925 26.3166 59.1625L33.111 52.3393L39.9054 59.1625C40.234 59.4925 40.6692 59.662 41.0955 59.662C41.5307 59.662 41.9571 59.4925 42.2857 59.1625C42.9429 58.5025 42.9429 57.4233 42.2857 56.7632L35.509 49.9401Z"
            fill="#ED1C24"
          />
          <path
            d="M129.999 48.5308V98.5495C129.999 103.294 126.163 107.148 121.437 107.148H39.2383C43.9633 107.148 47.8001 103.294 47.8001 98.5495V48.5308H129.999Z"
            fill="#FFBD39"
          />
          <path
            d="M78.4087 81.935C80.0735 80.2631 80.0735 77.5524 78.4087 75.8805C76.7438 74.2086 74.0446 74.2086 72.3797 75.8805C70.7149 77.5524 70.7149 80.2631 72.3797 81.935C74.0446 83.6069 76.7438 83.6069 78.4087 81.935Z"
            fill="#F7931E"
          />
          <path
            d="M68.6371 71.5781C68.193 71.5781 67.7756 71.3105 67.6157 70.8646C67.4025 70.2937 67.6867 69.6694 68.2552 69.4553L79.0019 65.406C79.5615 65.192 80.192 65.4774 80.4052 66.0482C80.6184 66.619 80.3341 67.2434 79.7657 67.4574L69.019 71.5068C68.8946 71.5514 68.7614 71.5781 68.6371 71.5781Z"
            fill="#F7931E"
          />
          <path
            d="M102.894 83.1352C105.219 82.7565 106.797 80.5574 106.42 78.2234C106.042 75.8895 103.853 74.3045 101.528 74.6833C99.2044 75.0621 97.6261 77.2612 98.0033 79.5951C98.3805 81.9291 100.57 83.514 102.894 83.1352Z"
            fill="#F7931E"
          />
          <path
            d="M108.968 71.578C108.843 71.578 108.71 71.5513 108.586 71.5067L97.8392 67.4574C97.2707 67.2433 96.9865 66.6101 97.1997 66.0481C97.4128 65.4862 98.0434 65.1919 98.603 65.406L109.35 69.4553C109.918 69.6693 110.202 70.3026 109.989 70.8645C109.829 71.3105 109.412 71.578 108.968 71.578Z"
            fill="#F7931E"
          />
          <path
            d="M91.4354 95.0179H86.1686C85.5647 95.0179 85.0762 94.5273 85.0762 93.9208C85.0762 93.3143 85.5647 92.8237 86.1686 92.8237H91.4354C92.0393 92.8237 92.5278 93.3143 92.5278 93.9208C92.5278 94.5273 92.0393 95.0179 91.4354 95.0179Z"
            fill="#F7931E"
          />
        </svg>
      )}
    </>
  );
};
